
/*******************************************************************************/
/*  
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021

*/
/*******************************************************************************/

/* Written and tested using version 16.0 */
/* Other versions should work fine.		 */
version 16.0 	

/*
/* Download necessary packages */
ssc install estout 
ssc install dataout 
ssc install coefplot 
ssc install egenmore
*/			

/* Set working directory */
global workdir "~/MPW_SocialDistancing_JEI2021_Replication/Do"
cd $workdir

/* Create LWFH HPP Measures */
do "1_clean_ONET.do"
do "2_clean_OES.do"
do "3_construct_exposure_measures.do"

/* Clean worker-level data */
do "4_essential_occupations.do"
do "5_clean_PSID.do"
do "6_clean_CPS.do"
do "7_clean_ATUS.do"

/* FIGURES */
do "fig1.do" 
do "fig2.do"
do "fig3.do"
do "fig4.do" 
do "fig5.do" 
do "fig6.do" 

do "figB1.do" 
do "figB2.do" 
do "figB3.do" 
do "figB4.do" 

/* TABLES */
do "table1.do"  

do "tableA1.do" 
do "tableA2.do" 
do "tableA3.do" 
do "tableA4.do" 

do "table_B1_B2_B3.do"
do "table_B4_B5.do"

// END